/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PregenManager {
    protected static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final AtomicReference<PregenState> pregenFuture = new AtomicReference();

    public CompletableFuture<Void> startPregen(IServerLevelWrapper levelWrapper, DhBlockPos2D origin, int chunkRadius) {
        PregenState pregenState = new PregenState((GeneratedFullDataSourceProvider)SharedApi.getIDhServerWorld().getLevel(levelWrapper).getFullDataProvider(), DhSectionPos.convertToDetailLevel(DhSectionPos.encode((byte)0, origin.x, origin.z), (byte)6), (int)Math.pow(Math.ceil((double)chunkRadius / 4.0 * 2.0), 2.0));
        if (!this.pregenFuture.compareAndSet(null, pregenState)) {
            pregenState.completeExceptionally(new IllegalStateException("Pregen is already running."));
            return pregenState;
        }
        pregenState.whenComplete((result, throwable) -> this.pregenFuture.set(null));
        pregenState.fillPendingQueue();
        return pregenState;
    }

    public CompletableFuture<Void> getRunningPregen() {
        return this.pregenFuture.get();
    }

    @Nullable
    public String getStatusString() {
        PregenState pregenState = this.pregenFuture.get();
        if (pregenState != null) {
            return pregenState.getStatusString();
        }
        return null;
    }

    private static class PregenState
    extends CompletableFuture<Void> {
        private final GeneratedFullDataSourceProvider fullDataSourceProvider;
        private final long originSectionPos;
        private final int sectionsToGenerate;
        private final AtomicInteger nextSectionSpiralIndex = new AtomicInteger(0);
        private final AtomicLong lastTaskStartTime = new AtomicLong(System.currentTimeMillis());
        private final RollingAverage averageTaskCompletionIntervalMs = new RollingAverage(200);
        private final AtomicLong lastLogTime = new AtomicLong();
        private final Cache<Long, Long> pendingGenerations = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).removalListener(removalNotification -> {
            if (removalNotification.getCause() == RemovalCause.EXPIRED) {
                LOGGER.warn("Generation for section " + DhSectionPos.toString((Long)removalNotification.getKey()) + " has expired!");
            }
            long timeSinceLastTaskStart = System.currentTimeMillis() - this.lastTaskStartTime.getAndSet(System.currentTimeMillis());
            this.averageTaskCompletionIntervalMs.addValue(timeSinceLastTaskStart);
            this.fillPendingQueue();
        }).build();

        public PregenState(GeneratedFullDataSourceProvider fullDataSourceProvider, long originSectionPos, int sectionsToGenerate) {
            this.fullDataSourceProvider = fullDataSourceProvider;
            this.originSectionPos = originSectionPos;
            this.sectionsToGenerate = sectionsToGenerate;
        }

        private void fillPendingQueue() {
            while (!this.isDone() && this.pendingGenerations.size() < (long)Config.Common.MultiThreading.numberOfThreads.get().intValue()) {
                int nextSpiralIndex = this.nextSectionSpiralIndex.getAndIncrement();
                if (nextSpiralIndex > this.sectionsToGenerate) {
                    this.complete(null);
                    return;
                }
                long nextSectionPos = this.sectionPosOnSpiral(nextSpiralIndex);
                long lastLogTime = this.lastLogTime.get();
                if (System.currentTimeMillis() - lastLogTime >= TimeUnit.SECONDS.toMillis(Config.Common.WorldGenerator.generationProgressDisplayIntervalInSeconds.get().intValue()) && this.lastLogTime.compareAndSet(lastLogTime, System.currentTimeMillis())) {
                    LOGGER.info(this.getStatusString());
                }
                this.pendingGenerations.put((Object)nextSectionPos, (Object)System.currentTimeMillis());
                this.fullDataSourceProvider.getAsync(nextSectionPos).thenAccept((T fullDataSource) -> {
                    if (this.fullDataSourceProvider.isFullyGenerated(fullDataSource.columnGenerationSteps)) {
                        this.pendingGenerations.invalidate((Object)fullDataSource.getPos());
                    } else {
                        this.fullDataSourceProvider.queuePositionForRetrieval(fullDataSource.getPos()).thenAccept(result -> {
                            if (!result.success) {
                                LOGGER.warn("Failed to generate section " + DhSectionPos.toString(result.pos));
                            }
                            this.pendingGenerations.invalidate((Object)result.pos);
                        });
                    }
                    fullDataSource.close();
                });
            }
        }

        public String getStatusString() {
            double etaMs = this.averageTaskCompletionIntervalMs.getAverage() * (double)(this.sectionsToGenerate - this.nextSectionSpiralIndex.get());
            return MessageFormat.format("Generated radius: {0,number,#.#} / {1,number,#.#} chunks ({2,number,#.#%}), ETA: {3}", Math.sqrt(this.nextSectionSpiralIndex.get()) / 2.0 * 4.0, Math.sqrt(this.sectionsToGenerate) / 2.0 * 4.0, (double)this.nextSectionSpiralIndex.get() / (double)this.sectionsToGenerate, Duration.ofMillis((long)etaMs).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").replaceAll("\\.\\d+", "").toLowerCase());
        }

        private long sectionPosOnSpiral(int index) {
            if (index == 0) {
                return this.originSectionPos;
            }
            int ringNumber = (int)Math.round(Math.sqrt(Math.floor((double)(--index) / 4.0) + 1.0));
            int x = -ringNumber + 1 + Math.min((index -= ringNumber * 8 * (ringNumber - 1) / 2) % (ringNumber * 4), ringNumber * 2 - 1);
            int z = ringNumber - Math.max(0, index % (ringNumber * 4) - ringNumber * 2 + 1);
            if (index >= ringNumber * 4) {
                x = -x;
                z = -z;
            }
            return DhSectionPos.encode(DhSectionPos.getDetailLevel(this.originSectionPos), x += DhSectionPos.getX(this.originSectionPos), z += DhSectionPos.getZ(this.originSectionPos));
        }
    }
}

