/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiChunkModifiedEvent;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.beacon.BeaconBeamDataHandler;
import com.seibel.distanthorizons.core.file.fullDatafile.DelayedFullDataSourceSaveCache;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.renderer.generic.CloudRenderHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.dto.ChunkHashDTO;
import com.seibel.distanthorizons.core.sql.repo.BeaconBeamRepo;
import com.seibel.distanthorizons.core.sql.repo.ChunkHashRepo;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDhLevel
implements IDhLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    @Nullable
    public ChunkHashRepo chunkHashRepo;
    @Nullable
    public BeaconBeamRepo beaconBeamRepo;
    protected final DelayedFullDataSourceSaveCache delayedFullDataSourceSaveCache = new DelayedFullDataSourceSaveCache(this::onDataSourceSaveAsync, 3000);
    protected final ConcurrentHashMap<Long, HashSet<DhChunkPos>> updatedChunkPosSetBySectionPos = new ConcurrentHashMap();
    protected final ConcurrentHashMap<DhChunkPos, Integer> updatedChunkHashesByChunkPos = new ConcurrentHashMap();
    @Nullable
    protected CloudRenderHandler cloudRenderHandler;
    protected BeaconBeamDataHandler beaconBeamDataHandler;

    protected AbstractDhLevel() {
    }

    protected void createAndSetSupportingRepos(File databaseFile) {
        ChunkHashRepo newChunkHashRepo = null;
        try {
            newChunkHashRepo = new ChunkHashRepo("jdbc:sqlite", databaseFile);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create [ChunkHashRepo], error: [" + e.getMessage() + "].", (Throwable)e);
        }
        this.chunkHashRepo = newChunkHashRepo;
        BeaconBeamRepo newBeaconBeamRepo = null;
        try {
            newBeaconBeamRepo = new BeaconBeamRepo("jdbc:sqlite", databaseFile);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create [BeaconBeamRepo], error: [" + e.getMessage() + "].", (Throwable)e);
        }
        this.beaconBeamRepo = newBeaconBeamRepo;
    }

    protected void runRepoReliantSetup() {
        GenericObjectRenderer genericRenderer = this.getGenericRenderer();
        if (genericRenderer != null && this instanceof IDhClientLevel && !this.getLevelWrapper().hasCeiling() && !this.getLevelWrapper().getDimensionType().isTheEnd()) {
            this.cloudRenderHandler = new CloudRenderHandler((IDhClientLevel)((Object)this), genericRenderer);
        }
        if (this.beaconBeamRepo != null) {
            this.beaconBeamDataHandler = new BeaconBeamDataHandler(this.beaconBeamRepo, genericRenderer);
        }
    }

    @Override
    public void updateChunkAsync(IChunkWrapper chunkWrapper, int chunkHash) {
        try (FullDataSourceV2 dataSource = FullDataSourceV2.createFromChunk(chunkWrapper);){
            if (dataSource == null) {
                return;
            }
            this.updatedChunkPosSetBySectionPos.compute(dataSource.getPos(), (dataSourcePos, chunkPosSet) -> {
                if (chunkPosSet == null) {
                    chunkPosSet = new HashSet<DhChunkPos>();
                }
                chunkPosSet.add(chunkWrapper.getChunkPos());
                return chunkPosSet;
            });
            this.updatedChunkHashesByChunkPos.put(chunkWrapper.getChunkPos(), chunkHash);
            this.delayedFullDataSourceSaveCache.writeDataSourceToMemoryAndQueueSave(dataSource);
        }
    }

    private CompletableFuture<Void> onDataSourceSaveAsync(FullDataSourceV2 fullDataSource) {
        DhLightingEngine.INSTANCE.bakeDataSourceSkyLight(fullDataSource, this.hasSkyLight() ? 15 : 0);
        return this.updateDataSourcesAsync(fullDataSource).thenRun(() -> {
            HashSet<DhChunkPos> updatedChunkPosSet = this.updatedChunkPosSetBySectionPos.remove(fullDataSource.getPos());
            if (updatedChunkPosSet != null) {
                for (DhChunkPos chunkPos : updatedChunkPosSet) {
                    Integer chunkHash = this.updatedChunkHashesByChunkPos.remove(chunkPos);
                    if (this.chunkHashRepo != null && chunkHash != null) {
                        this.chunkHashRepo.save(new ChunkHashDTO(chunkPos, chunkHash));
                    }
                    ApiEventInjector.INSTANCE.fireAllEvents(DhApiChunkModifiedEvent.class, new DhApiChunkModifiedEvent.EventParam(this.getLevelWrapper(), chunkPos.getX(), chunkPos.getZ()));
                }
            }
        });
    }

    @Override
    public int getChunkHash(DhChunkPos pos) {
        if (this.chunkHashRepo == null) {
            return 0;
        }
        ChunkHashDTO dto = (ChunkHashDTO)this.chunkHashRepo.getByKey(pos);
        return dto != null ? dto.chunkHash : 0;
    }

    @Override
    public void updateBeaconBeamsForChunk(IChunkWrapper chunkToUpdate, ArrayList<IChunkWrapper> nearbyChunkList) {
        if (this.beaconBeamDataHandler != null) {
            List<BeaconBeamDTO> activeBeamList = chunkToUpdate.getAllActiveBeacons(nearbyChunkList);
            this.beaconBeamDataHandler.setBeaconBeamsForChunk(chunkToUpdate.getChunkPos(), activeBeamList);
        }
    }

    @Override
    public void loadBeaconBeamsInPos(long pos) {
        if (this.beaconBeamDataHandler != null) {
            this.beaconBeamDataHandler.loadBeaconBeamsInPos(pos);
        }
    }

    @Override
    public void unloadBeaconBeamsInPos(long pos) {
        if (this.beaconBeamDataHandler != null) {
            this.beaconBeamDataHandler.unloadBeaconBeamsInPos(pos);
        }
    }

    @Override
    public void close() {
        if (this.chunkHashRepo != null) {
            this.chunkHashRepo.close();
        }
        if (this.beaconBeamRepo != null) {
            this.beaconBeamRepo.close();
        }
        this.delayedFullDataSourceSaveCache.close();
    }
}

