/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.client;

import com.google.common.base.Stopwatch;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.multiplayer.client.ClientNetworkState;
import com.seibel.distanthorizons.core.network.exceptions.RateLimitedException;
import com.seibel.distanthorizons.core.network.exceptions.RequestOutOfRangeException;
import com.seibel.distanthorizons.core.network.exceptions.RequestRejectedException;
import com.seibel.distanthorizons.core.network.exceptions.SectionRequiresSplittingException;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceRequestMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceResponseMessage;
import com.seibel.distanthorizons.core.network.session.SessionClosedException;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ratelimiting.SupplierBasedRateLimiter;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;

public abstract class AbstractFullDataNetworkRequestQueue
implements IDebugRenderable,
AutoCloseable {
    private static final ConfigBasedSpamLogger LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger(), () -> Config.Common.Logging.logNetworkEvent.get(), 3);
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final int MAX_RETRY_ATTEMPTS = 3;
    protected static final long SHUTDOWN_TIMEOUT_SECONDS = 5L;
    public final ClientNetworkState networkState;
    protected final DhClientLevel level;
    private final boolean changedOnly;
    private volatile CompletableFuture<Void> closingFuture = null;
    protected final ConcurrentMap<Long, RequestQueueEntry> waitingTasksBySectionPos = new ConcurrentHashMap<Long, RequestQueueEntry>();
    private final Semaphore pendingTasksSemaphore = new Semaphore(Short.MAX_VALUE, true);
    private final AtomicInteger finishedRequests = new AtomicInteger();
    private final AtomicInteger failedRequests = new AtomicInteger();
    private final ConfigEntry<Boolean> showDebugWireframeConfig;
    private final SupplierBasedRateLimiter<Void> rateLimiter = new SupplierBasedRateLimiter(this::getRequestRateLimit);

    public AbstractFullDataNetworkRequestQueue(ClientNetworkState networkState, DhClientLevel level, boolean changedOnly, ConfigEntry<Boolean> showDebugWireframeConfig) {
        this.networkState = networkState;
        this.level = level;
        this.changedOnly = changedOnly;
        this.showDebugWireframeConfig = showDebugWireframeConfig;
        DebugRenderer.register(this, this.showDebugWireframeConfig);
    }

    protected abstract int getRequestRateLimit();

    protected abstract int getMaxRequestDistance();

    protected abstract String getQueueName();

    public CompletableFuture<RequestResult> submitRequest(long sectionPos, Consumer<FullDataSourceV2> dataSourceConsumer) {
        return this.submitRequest(sectionPos, null, dataSourceConsumer);
    }

    public CompletableFuture<RequestResult> submitRequest(long sectionPos, @Nullable Long clientTimestamp, Consumer<FullDataSourceV2> dataSourceConsumer) {
        AtomicBoolean added = new AtomicBoolean(false);
        RequestQueueEntry entry = this.waitingTasksBySectionPos.compute(sectionPos, (k, existingQueueEntry) -> {
            if (existingQueueEntry != null) {
                return existingQueueEntry;
            }
            RequestQueueEntry newEntry = new RequestQueueEntry(dataSourceConsumer, clientTimestamp);
            newEntry.future.whenComplete((requestResult, throwable) -> {
                this.waitingTasksBySectionPos.remove(sectionPos);
                switch (requestResult.ordinal()) {
                    case 0: {
                        this.finishedRequests.incrementAndGet();
                        return;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.failedRequests.incrementAndGet();
                        return;
                    }
                }
                if (throwable != null && !(throwable instanceof CancellationException)) {
                    this.failedRequests.incrementAndGet();
                }
            });
            added.set(true);
            return newEntry;
        });
        if (!added.get()) {
            return CompletableFuture.completedFuture(RequestResult.FAILED);
        }
        return entry.future;
    }

    public synchronized boolean tick(DhBlockPos2D targetPos) {
        if (DhApiWorldProxy.INSTANCE.worldLoaded() && DhApiWorldProxy.INSTANCE.getReadOnly()) {
            return false;
        }
        if (this.closingFuture != null || !this.networkState.isReady()) {
            return false;
        }
        while (this.getInProgressTaskCount() < this.getWaitingTaskCount() && this.getInProgressTaskCount() < this.getRequestRateLimit() && this.pendingTasksSemaphore.tryAcquire()) {
            if (!this.rateLimiter.tryAcquire()) {
                this.pendingTasksSemaphore.release();
                break;
            }
            this.sendNextRequest(targetPos);
        }
        return true;
    }

    private void sendNextRequest(DhBlockPos2D targetPos) {
        Map.Entry mapEntry = this.waitingTasksBySectionPos.entrySet().stream().filter(task -> ((RequestQueueEntry)task.getValue()).networkDataSourceFuture == null).min(Comparator.comparingInt(x -> DhSectionPos.getChebyshevSignedBlockDistance((Long)x.getKey(), targetPos))).orElse(null);
        if (mapEntry == null) {
            this.pendingTasksSemaphore.release();
            return;
        }
        long sectionPos = (Long)mapEntry.getKey();
        RequestQueueEntry entry = (RequestQueueEntry)mapEntry.getValue();
        if (DhSectionPos.getChebyshevSignedBlockDistance(sectionPos, targetPos) > this.getMaxRequestDistance() * 16) {
            entry.future.cancel(false);
            this.pendingTasksSemaphore.release();
            return;
        }
        Long offsetEntryTimestamp = entry.updateTimestamp != null ? Long.valueOf(entry.updateTimestamp + this.networkState.getServerTimeOffset()) : null;
        CompletableFuture<FullDataSourceResponseMessage> dataSourceFuture = this.networkState.getSession().sendRequest(new FullDataSourceRequestMessage(this.level.getLevelWrapper(), sectionPos, offsetEntryTimestamp), FullDataSourceResponseMessage.class);
        entry.networkDataSourceFuture = dataSourceFuture;
        dataSourceFuture.handle((response, throwable) -> {
            this.pendingTasksSemaphore.release();
            try {
                if (throwable != null) {
                    throw throwable;
                }
                if (response.payload != null) {
                    FullDataSourceV2DTO dataSourceDto = this.networkState.fullDataPayloadReceiver.decodeDataSourceAndReleaseBuffer(response.payload);
                    PriorityTaskPicker.Executor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
                    if (executor == null) {
                        LOGGER.warn("Unable to handle FullDataPayload - getNetworkCompressionExecutor() is null", new Object[0]);
                        return null;
                    }
                    CompletableFuture.runAsync(() -> {
                        try {
                            this.level.getBeaconBeamDataHandler().setBeaconBeamsForPos(dataSourceDto.pos, response.payload.beaconBeams);
                            try (FullDataSourceV2 fullDataSource = dataSourceDto.createDataSource(this.level.getLevelWrapper());){
                                entry.dataSourceConsumer.accept(fullDataSource);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }, executor);
                } else {
                    LodUtil.assertTrue(this.changedOnly, "Received empty data source response for not changes-only request");
                }
            }
            catch (SectionRequiresSplittingException ignored) {
                return entry.future.complete(RequestResult.REQUIRES_SPLITTING);
            }
            catch (SessionClosedException | CancellationException ignored) {
                return entry.future.cancel(false);
            }
            catch (RequestRejectedException e) {
                LOGGER.info("Request rejected by the server: " + e.getMessage(), new Object[0]);
                return entry.future.complete(RequestResult.FAILED);
            }
            catch (RateLimitedException e) {
                LOGGER.warn("Rate limited by server, re-queueing task [" + DhSectionPos.toString(sectionPos) + "]: " + e.getMessage(), new Object[0]);
                this.rateLimiter.acquireAll();
                entry.networkDataSourceFuture = null;
                return null;
            }
            catch (RequestOutOfRangeException e) {
                LOGGER.debug("Out of range, re-queueing task [" + DhSectionPos.toString(sectionPos) + "]: " + e.getMessage(), new Object[0]);
                entry.networkDataSourceFuture = null;
                return null;
            }
            catch (Throwable e) {
                --entry.retryAttempts;
                LOGGER.error("Error while fetching full data source, attempts left: {} / {}", entry.retryAttempts, 3, e);
                if (entry.retryAttempts > 0) {
                    entry.networkDataSourceFuture = null;
                    return null;
                }
                return entry.future.complete(RequestResult.FAILED);
            }
            return entry.future.complete(RequestResult.SUCCEEDED);
        });
    }

    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
        for (Map.Entry mapEntry : this.waitingTasksBySectionPos.entrySet().stream().sorted(Comparator.comparingInt(entry -> DhSectionPos.getChebyshevSignedBlockDistance((Long)entry.getKey(), Objects.requireNonNull(this.level.getTargetPosForGeneration()))).reversed())::iterator) {
            long pos = (Long)mapEntry.getKey();
            RequestQueueEntry entry2 = (RequestQueueEntry)mapEntry.getValue();
            if (!removeIf.accept(pos)) continue;
            LOGGER.debug("Removing request  " + mapEntry.getKey() + "...", new Object[0]);
            entry2.future.cancel(false);
            if (entry2.networkDataSourceFuture == null) continue;
            entry2.networkDataSourceFuture.cancel(false);
        }
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        messageList.add(this.getQueueName() + " [" + this.level.getClientLevelWrapper().getDhIdentifier() + "]");
        messageList.add("Requests: " + this.finishedRequests + " / " + (this.getWaitingTaskCount() + this.finishedRequests.get()) + " (failed: " + this.failedRequests + ", rate limit: " + this.getRequestRateLimit() + ")");
    }

    public int getWaitingTaskCount() {
        return this.waitingTasksBySectionPos.size();
    }

    public int getInProgressTaskCount() {
        return Short.MAX_VALUE - this.pendingTasksSemaphore.availablePermits();
    }

    public CompletableFuture<Void> startClosingAsync(boolean alsoInterruptRunning) {
        this.closingFuture = CompletableFuture.runAsync(() -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            do {
                for (RequestQueueEntry entry : this.waitingTasksBySectionPos.values()) {
                    entry.future.cancel(alsoInterruptRunning);
                    if (entry.networkDataSourceFuture == null || !entry.networkDataSourceFuture.cancel(alsoInterruptRunning)) continue;
                    this.pendingTasksSemaphore.release();
                }
            } while (!this.pendingTasksSemaphore.tryAcquire(Short.MAX_VALUE) && stopwatch.elapsed(TimeUnit.SECONDS) < 5L);
            if (stopwatch.elapsed(TimeUnit.SECONDS) >= 5L) {
                LOGGER.warn("The request queue [" + this.getQueueName() + "] for level [" + this.level.getLevelWrapper() + "] did not shutdown in [" + 5L + "] seconds. Some unfinished tasks might be left hanging.", new Object[0]);
            }
        });
        return this.closingFuture;
    }

    @Override
    public void close() {
        DebugRenderer.unregister(this, this.showDebugWireframeConfig);
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        if (MC_CLIENT.getWrappedClientLevel() != this.level.getClientLevelWrapper()) {
            return;
        }
        for (Map.Entry mapEntry : this.waitingTasksBySectionPos.entrySet()) {
            renderer.renderBox(new DebugRenderer.Box((Long)mapEntry.getKey(), -32.0f, 64.0f, 0.05f, ((RequestQueueEntry)mapEntry.getValue()).networkDataSourceFuture != null ? Color.red : (DhSectionPos.getChebyshevSignedBlockDistance((Long)mapEntry.getKey(), Objects.requireNonNull(this.level.getTargetPosForGeneration())) <= this.getMaxRequestDistance() * 16 ? Color.gray : Color.darkGray)));
        }
    }

    protected static class RequestQueueEntry {
        public final CompletableFuture<RequestResult> future = new CompletableFuture();
        public final Consumer<FullDataSourceV2> dataSourceConsumer;
        @Nullable
        public final Long updateTimestamp;
        @CheckForNull
        public CompletableFuture<FullDataSourceResponseMessage> networkDataSourceFuture;
        public int retryAttempts = 3;

        public RequestQueueEntry(Consumer<FullDataSourceV2> dataSourceConsumer, @Nullable Long updateTimestamp) {
            this.dataSourceConsumer = dataSourceConsumer;
            this.updateTimestamp = updateTimestamp;
        }
    }

    public static enum RequestResult {
        SUCCEEDED,
        REQUIRES_SPLITTING,
        FAILED;

    }
}

