/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pooling;

import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.util.ListUtil;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class PhantomArrayListCheckout
implements AutoCloseable {
    private final PhantomArrayListPool owningPool;
    @Nullable
    public final String allocationStackTrace;
    private final ArrayList<ByteArrayList> byteArrayLists = new ArrayList();
    private final ArrayList<ShortArrayList> shortArrayLists = new ArrayList();
    private final ArrayList<LongArrayList> longArrayLists = new ArrayList();
    private final ArrayList<SoftReference<LongArrayList>> longArrayRefLists = new ArrayList();

    public PhantomArrayListCheckout(PhantomArrayListPool owningPool) {
        this.allocationStackTrace = owningPool.logGarbageCollectedStacks ? StringUtil.join("\n", Thread.currentThread().getStackTrace()) : null;
        this.owningPool = owningPool;
    }

    public void addByteArrayList(ByteArrayList list) {
        this.byteArrayLists.add(list);
    }

    public void addShortArrayList(ShortArrayList list) {
        this.shortArrayLists.add(list);
    }

    public void addLongArrayListRef(LongArrayList list, SoftReference<LongArrayList> listRef) {
        this.longArrayLists.add(list);
        this.longArrayRefLists.add(listRef);
    }

    public int getByteArrayCount() {
        return this.byteArrayLists.size();
    }

    public int getShortArrayCount() {
        return this.shortArrayLists.size();
    }

    public int getLongArrayCount() {
        return this.longArrayLists.size();
    }

    public ByteArrayList getByteArray(int index, int size) {
        ByteArrayList list = this.byteArrayLists.get(index);
        ListUtil.clearAndSetSize(list, size);
        return list;
    }

    public ShortArrayList getShortArray(int index, int size) {
        ShortArrayList list = this.shortArrayLists.get(index);
        ListUtil.clearAndSetSize(list, size);
        return list;
    }

    public LongArrayList getLongArray(int index, int size) {
        LongArrayList list = this.longArrayLists.get(index);
        ListUtil.clearAndSetSize(list, size);
        return list;
    }

    public ArrayList<ByteArrayList> getAllByteArrays() {
        return this.byteArrayLists;
    }

    public ArrayList<ShortArrayList> getAllShortArrays() {
        return this.shortArrayLists;
    }

    public ArrayList<LongArrayList> getAllLongArrays() {
        return this.longArrayLists;
    }

    public ArrayList<SoftReference<LongArrayList>> getAllLongArrayRefs() {
        return this.longArrayRefLists;
    }

    @Override
    public void close() {
        this.owningPool.returnCheckout(this);
    }
}

