/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pooling;

import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import java.lang.ref.PhantomReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PhantomArrayListParent
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PhantomArrayListPool phantomArrayListPool;
    private final PhantomReference<PhantomArrayListParent> phantomReference;
    protected PhantomArrayListCheckout pooledArraysCheckout;

    public PhantomArrayListParent(PhantomArrayListPool phantomArrayListPool, int byteArrayCount, int shortArrayCount, int longArrayCount) {
        if (byteArrayCount < 0 || shortArrayCount < 0 || longArrayCount < 0) {
            throw new IllegalArgumentException("Can't get a negative number of pooled arrays.");
        }
        this.phantomArrayListPool = phantomArrayListPool;
        this.phantomReference = new PhantomReference<PhantomArrayListParent>(this, this.phantomArrayListPool.phantomRefQueue);
        this.pooledArraysCheckout = this.phantomArrayListPool.checkoutArrays(byteArrayCount, shortArrayCount, longArrayCount);
        this.phantomArrayListPool.phantomRefToCheckout.put(this.phantomReference, this.pooledArraysCheckout);
    }

    @Override
    public void close() {
        try {
            this.phantomReference.clear();
            PhantomArrayListCheckout checkout = this.phantomArrayListPool.phantomRefToCheckout.remove(this.phantomReference);
            this.phantomArrayListPool.returnCheckout(checkout);
        }
        catch (Exception e) {
            LOGGER.error("Unable to close Phantom Array", (Throwable)e);
        }
    }
}

