/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.sql.DatabaseUpdater;
import com.seibel.distanthorizons.core.sql.DbConnectionClosedException;
import com.seibel.distanthorizons.core.sql.dto.IBaseDTO;
import com.seibel.distanthorizons.core.util.KeyedLockContainer;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDhRepo<TKey, TDTO extends IBaseDTO<TKey>>
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final String DEFAULT_DATABASE_TYPE = "jdbc:sqlite";
    public static final int TIMEOUT_SECONDS = 0;
    private static final ConcurrentHashMap<String, Connection> CONNECTIONS_BY_CONNECTION_STRING = new ConcurrentHashMap();
    private static final ConcurrentHashMap<AbstractDhRepo<?, ?>, String> ACTIVE_CONNECTION_STRINGS_BY_REPO = new ConcurrentHashMap();
    private final String connectionString;
    private final Connection connection;
    public final String databaseType;
    public final File databaseFile;
    public final Class<? extends TDTO> dtoClass;
    protected final KeyedLockContainer<TKey> saveLockContainer = new KeyedLockContainer();
    private String selectSqlTemplate = null;
    private String existsSqlTemplate = null;
    private String deleteSqlTemplate = null;

    public AbstractDhRepo(String databaseType, File databaseFile, Class<? extends TDTO> dtoClass) throws SQLException {
        this.databaseType = databaseType;
        this.databaseFile = databaseFile;
        this.dtoClass = dtoClass;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!databaseFile.exists()) {
            File parentFolder = databaseFile.getParentFile();
            if (parentFolder != null && !parentFolder.exists() && !parentFolder.mkdirs()) {
                throw new RuntimeException("Unable to create the necessary parent folders for the database file at location [" + databaseFile.getPath() + "].");
            }
            if (!databaseFile.exists()) {
                try {
                    boolean bl = databaseFile.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to create database file at location [" + databaseFile.getPath() + "] due to error: [" + e.getMessage() + "]", e);
                }
            }
        }
        if (!databaseFile.canRead()) {
            throw new RuntimeException("Unable to read database file at location [" + databaseFile.getPath() + "], please make sure the folder and file has the correct permissions.");
        }
        if (!databaseFile.canWrite()) {
            throw new RuntimeException("Unable to write database file at location [" + databaseFile.getPath() + "], please make sure the folder and file aren't set to read-only.");
        }
        this.connectionString = this.databaseType + ":" + this.databaseFile.getPath();
        this.connection = CONNECTIONS_BY_CONNECTION_STRING.computeIfAbsent(this.connectionString, connectionString -> {
            try {
                return DriverManager.getConnection(connectionString);
            }
            catch (SQLException e) {
                LOGGER.error("Unable to connect to database with the connection string: [" + connectionString + "]");
                return null;
            }
        });
        if (this.connection == null) {
            throw new SQLException("Unable to get repo with connection string [" + this.connectionString + "]");
        }
        ACTIVE_CONNECTION_STRINGS_BY_REPO.put(this, this.connectionString);
        DatabaseUpdater.runAutoUpdateScripts(this);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TDTO getByKey(TKey primaryKey) {
        try (PreparedStatement statement = this.createSelectStatementByKey(primaryKey);){
            TDTO TDTO;
            block18: {
                ResultSet resultSet;
                block16: {
                    TDTO TDTO2;
                    block17: {
                        resultSet = this.query(statement);
                        try {
                            if (resultSet == null || !resultSet.next()) break block16;
                            TDTO2 = this.convertResultSetToDto(resultSet);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return TDTO2;
                }
                TDTO = null;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return TDTO;
        }
        catch (IOException | SQLException e) {
            LOGGER.warn("Unexpected issue deserializing DTO [" + this.dtoClass.getSimpleName() + "] with primary key [" + primaryKey + "]. Error: [" + e.getMessage() + "].", (Throwable)e);
            return null;
        }
    }

    public void save(TDTO dto) {
        ReentrantLock saveLock = this.saveLockContainer.getLockForPos(dto.getKey());
        try {
            saveLock.lock();
            if (this.existsWithKey(dto.getKey())) {
                this.update(dto);
            } else {
                this.insert(dto);
            }
        }
        finally {
            saveLock.unlock();
        }
    }

    private void insert(TDTO dto) {
        try (PreparedStatement statement2 = this.createInsertStatement(dto);){
            this.query(statement2);
        }
        catch (DbConnectionClosedException statement2) {
        }
        catch (SQLException e) {
            String message = "Unexpected DTO insert error: [" + e.getMessage() + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    private void update(TDTO dto) {
        try (PreparedStatement statement2 = this.createUpdateStatement(dto);){
            this.query(statement2);
        }
        catch (DbConnectionClosedException statement2) {
        }
        catch (SQLException e) {
            String message = "Unexpected DTO update error: [" + e.getMessage() + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    public void delete(TDTO dto) {
        this.deleteWithKey(dto.getKey());
    }

    public void deleteWithKey(TKey key) {
        try (PreparedStatement statement = this.createDeleteStatementByKey(key);){
            this.query(statement);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAll() {
        String sql = "DELETE FROM " + this.getTableName();
        try (PreparedStatement statement = this.createPreparedStatement(sql);){
            this.query(statement);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exists(TDTO dto) {
        return this.existsWithKey(dto.getKey());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean existsWithKey(TKey key) {
        try (PreparedStatement statement = this.createExistsStatementByKey(key);){
            boolean bl;
            block14: {
                ResultSet result = this.query(statement);
                try {
                    boolean bl2 = bl = result != null && result.getInt("existingCount") != 0;
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Nullable
    public Map<String, Object> queryDictionaryFirst(String sql) {
        try {
            List<Map<String, Object>> objectList = this.queryDictionary(sql);
            return !objectList.isEmpty() ? objectList.get(0) : null;
        }
        catch (DbConnectionClosedException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> queryDictionary(String sql) throws RuntimeException, DbConnectionClosedException {
        try (Statement statement = this.connection.createStatement();){
            List<Map<String, Object>> list;
            block15: {
                statement.setQueryTimeout(0);
                boolean resultSetPresent = statement.execute(sql);
                ResultSet resultSet = statement.getResultSet();
                try {
                    list = this.convertResultSetToDictionaryList(resultSet, resultSetPresent);
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException e) {
            if (DbConnectionClosedException.IsClosedException(e)) {
                throw new DbConnectionClosedException(e);
            }
            String message = "Unexpected Query error: [" + e.getMessage() + "], for script: [" + sql + "].";
            LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    @Nullable
    public ResultSet query(@Nullable PreparedStatement statement) throws RuntimeException {
        if (statement == null) {
            return null;
        }
        try {
            statement.setQueryTimeout(0);
            boolean resultSetPresent = statement.execute();
            if (resultSetPresent) {
                return statement.getResultSet();
            }
            return null;
        }
        catch (SQLException e) {
            if (DbConnectionClosedException.IsClosedException(e)) {
                return null;
            }
            String message = "Unexpected Query error: [" + e.getMessage() + "], for prepared statement: [" + statement + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    @Nullable
    public PreparedStatement createPreparedStatement(String sql) throws RuntimeException {
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setQueryTimeout(0);
            return statement;
        }
        catch (SQLException e) {
            if (DbConnectionClosedException.IsClosedException(e)) {
                return null;
            }
            String message = "Unexpected error: [" + e.getMessage() + "], preparing statement: [" + sql + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isConnected() {
        try {
            return this.connection != null && this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static void closeAllConnections() {
        LOGGER.info("Closing all [" + ACTIVE_CONNECTION_STRINGS_BY_REPO.size() + "] database connections...");
        for (String connectionString : ACTIVE_CONNECTION_STRINGS_BY_REPO.values()) {
            try {
                Connection connection = CONNECTIONS_BY_CONNECTION_STRING.remove(connectionString);
                if (connection == null) continue;
                if (!connection.isClosed()) {
                    LOGGER.info("Closing database connection: [" + connectionString + "]");
                    connection.close();
                    continue;
                }
                LOGGER.warn("Attempting to close already closed database connection: [" + connectionString + "]");
            }
            catch (SQLException e) {
                LOGGER.error("Unable to close the connection [" + connectionString + "], error: [" + e.getMessage() + "]");
            }
        }
    }

    @Override
    public void close() {
        try {
            ACTIVE_CONNECTION_STRINGS_BY_REPO.remove(this);
            if (!ACTIVE_CONNECTION_STRINGS_BY_REPO.containsValue(this.connectionString)) {
                if (this.connection != null) {
                    CONNECTIONS_BY_CONNECTION_STRING.remove(this.connectionString);
                    if (!this.connection.isClosed()) {
                        LOGGER.info("Closing database connection: [" + this.connectionString + "]...");
                        this.connection.close();
                        LOGGER.info("Finished closing database connection: [" + this.connectionString + "]");
                    } else {
                        LOGGER.warn("Attempting to close already closed database connection: [" + this.connectionString + "]");
                    }
                }
                ACTIVE_CONNECTION_STRINGS_BY_REPO.remove(this);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unable to close the connection [" + this.connectionString + "], error: [" + e.getMessage() + "]");
        }
    }

    private List<Map<String, Object>> convertResultSetToDictionaryList(ResultSet resultSet, boolean resultSetPresent) throws SQLException {
        if (resultSetPresent) {
            List<Map<String, Object>> resultList = AbstractDhRepo.convertResultSetToDictionaryList(resultSet);
            resultSet.close();
            return resultList;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        return new ArrayList<Map<String, Object>>();
    }

    private static List<Map<String, Object>> convertResultSetToDictionaryList(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData resultMetaData = resultSet.getMetaData();
        int resultColumnCount = resultMetaData.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> object = new HashMap<String, Object>();
            for (int columnIndex = 1; columnIndex <= resultColumnCount; ++columnIndex) {
                Object columnValue;
                String columnType;
                String columnName = resultMetaData.getColumnName(columnIndex);
                if (columnName == null || columnName.isEmpty()) {
                    throw new RuntimeException("SQL result set is missing a column name for column [" + resultMetaData.getTableName(columnIndex) + "." + columnIndex + "].");
                }
                switch (columnType = resultMetaData.getColumnTypeName(columnIndex).toUpperCase()) {
                    case "BIGINT": {
                        columnValue = resultSet.getLong(columnIndex);
                        break;
                    }
                    case "SMALLINT": {
                        columnValue = resultSet.getShort(columnIndex);
                        break;
                    }
                    case "TINYINT": {
                        columnValue = resultSet.getByte(columnIndex);
                        break;
                    }
                    default: {
                        columnValue = resultSet.getObject(columnIndex);
                    }
                }
                object.put(columnName, columnValue);
            }
            list.add(object);
        }
        return list;
    }

    public abstract String getTableName();

    @Nullable
    public abstract TDTO convertResultSetToDto(ResultSet var1) throws ClassCastException, IOException, SQLException;

    protected abstract String CreateParameterizedWhereString();

    protected void setPreparedStatementWhereClause(PreparedStatement statement, TKey key) throws SQLException {
        this.setPreparedStatementWhereClause(statement, 1, key);
    }

    protected abstract int setPreparedStatementWhereClause(PreparedStatement var1, int var2, TKey var3) throws SQLException;

    public PreparedStatement createSelectStatementByKey(TKey key) throws SQLException {
        PreparedStatement statement;
        if (this.selectSqlTemplate == null) {
            this.selectSqlTemplate = "SELECT * FROM " + this.getTableName() + " WHERE " + this.CreateParameterizedWhereString();
        }
        if ((statement = this.createPreparedStatement(this.selectSqlTemplate)) == null) {
            return null;
        }
        this.setPreparedStatementWhereClause(statement, key);
        return statement;
    }

    public PreparedStatement createExistsStatementByKey(TKey key) throws SQLException {
        PreparedStatement statement;
        if (this.existsSqlTemplate == null) {
            this.existsSqlTemplate = "SELECT EXISTS(SELECT 1 FROM " + this.getTableName() + " WHERE " + this.CreateParameterizedWhereString() + ") as 'existingCount'";
        }
        if ((statement = this.createPreparedStatement(this.existsSqlTemplate)) == null) {
            return null;
        }
        this.setPreparedStatementWhereClause(statement, key);
        return statement;
    }

    public PreparedStatement createDeleteStatementByKey(TKey key) throws SQLException {
        PreparedStatement statement;
        if (this.deleteSqlTemplate == null) {
            this.deleteSqlTemplate = "DELETE FROM " + this.getTableName() + " WHERE " + this.CreateParameterizedWhereString();
        }
        if ((statement = this.createPreparedStatement(this.deleteSqlTemplate)) == null) {
            return null;
        }
        this.setPreparedStatementWhereClause(statement, key);
        return statement;
    }

    @Nullable
    public abstract PreparedStatement createInsertStatement(TDTO var1) throws SQLException;

    @Nullable
    public abstract PreparedStatement createUpdateStatement(TDTO var1) throws SQLException;
}

