/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Objects;
import java.util.Set;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.ticks.LevelChunkTicks;

public class ChunkLoader {
    private static boolean zeroChunkPosErrorLogged = false;
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW((IdMap)Block.BLOCK_STATE_REGISTRY, (Codec)BlockState.CODEC, (PalettedContainer.Strategy)PalettedContainer.Strategy.SECTION_STATES, (Object)Blocks.AIR.defaultBlockState());
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;
    private static boolean lightingSectionErrorLogged = false;

    public static LevelChunk read(WorldGenLevel level, ChunkPos chunkPos, CompoundTag chunkData) {
        CompoundTag tagLevel = chunkData;
        ChunkPos actualPos = new ChunkPos(tagLevel.getInt("xPos"), tagLevel.getInt("zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            if (actualPos.equals((Object)ChunkPos.ZERO)) {
                if (!zeroChunkPosErrorLogged) {
                    zeroChunkPosErrorLogged = true;
                    LOGGER.warn("Chunk file at [" + chunkPos.toString() + "] doesn't have a chunk pos. \nThis might happen if the world was created using an external program. \nDH will attempt to parse the chunk anyway and won't log this message again.\nIf issues arise please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.", new Object[0]);
                }
            } else {
                LOGGER.error("Chunk file at [" + chunkPos.toString() + "] is in the wrong location. \nPlease try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. \n(Expected pos: [" + chunkPos.toString() + "], actual [" + actualPos.toString() + "])", new Object[0]);
                return null;
            }
        }
        ChunkType chunkType = ChunkLoader.readChunkType(tagLevel);
        BlendingData blendingData = ChunkLoader.readBlendingData(tagLevel);
        if (chunkType == ChunkType.PROTOCHUNK && blendingData == null) {
            return null;
        }
        long inhabitedTime = tagLevel.getLong("InhabitedTime");
        UpgradeData upgradeData = tagLevel.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData(tagLevel.getCompound(TAG_UPGRADE_DATA), (LevelHeightAccessor)level) : UpgradeData.EMPTY;
        boolean isLightOn = tagLevel.getBoolean("isLightOn");
        LevelChunkTicks blockTicks = LevelChunkTicks.load((ListTag)tagLevel.getList(BLOCK_TICKS_TAG_18, 10), string -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse((String)string)), (ChunkPos)chunkPos);
        LevelChunkTicks fluidTicks = LevelChunkTicks.load((ListTag)tagLevel.getList(FLUID_TICKS_TAG_18, 10), string -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse((String)string)), (ChunkPos)chunkPos);
        LevelChunkSection[] levelChunkSections = ChunkLoader.readSections((LevelAccessor)level, chunkPos, tagLevel);
        LevelChunk chunk = new LevelChunk((Level)level, chunkPos, upgradeData, blockTicks, fluidTicks, inhabitedTime, levelChunkSections, null, blendingData);
        chunk.setLightCorrect(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        ChunkLoader.readPostPocessings(chunk, chunkData);
        return chunk;
    }

    private static LevelChunkSection[] readSections(LevelAccessor level, ChunkPos chunkPos, CompoundTag chunkData) {
        Registry biomes = level.registryAccess().lookupOrThrow(Registries.BIOME);
        Codec biomeCodec = PalettedContainer.codecRW((IdMap)biomes.asHolderIdMap(), (Codec)biomes.holderByNameCodec(), (PalettedContainer.Strategy)PalettedContainer.Strategy.SECTION_BIOMES, (Object)biomes.getOrThrow(Biomes.PLAINS));
        int sectionYIndex = level.getSectionsCount();
        LevelChunkSection[] chunkSections = new LevelChunkSection[sectionYIndex];
        boolean isLightOn = chunkData.getBoolean("isLightOn");
        boolean hasSkyLight = level.dimensionType().hasSkyLight();
        ListTag tagSections = chunkData.getList("Sections", 10);
        if (tagSections.isEmpty()) {
            tagSections = chunkData.getList("sections", 10);
        }
        for (int j = 0; j < tagSections.size(); ++j) {
            CompoundTag tagSection = tagSections.getCompound(j);
            byte sectionYPos = tagSection.getByte("Y");
            int sectionId = level.getSectionIndexFromSectionY((int)sectionYPos);
            if (sectionId < 0 || sectionId >= chunkSections.length) continue;
            PalettedContainer blockStateContainer = tagSection.contains("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tagSection.getCompound("block_states")).promotePartial(string -> ChunkLoader.logBlockDeserializationWarning(chunkPos, sectionYPos, string)).getOrThrow(message -> (RuntimeException)LOGGER.errorAndThrow((String)message, null)) : new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
            PalettedContainer biomeContainer = tagSection.contains("biomes", 10) ? (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tagSection.getCompound("biomes")).promotePartial(string -> ChunkLoader.logBiomeDeserializationWarning(chunkPos, sectionYIndex, string)).getOrThrow(message -> (RuntimeException)LOGGER.errorAndThrow((String)message, null)) : new PalettedContainer(biomes.asHolderIdMap(), (Object)biomes.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
            chunkSections[sectionId] = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
        }
        return chunkSections;
    }

    private static ChunkType readChunkType(CompoundTag tagLevel) {
        ChunkStatus chunkStatus = ChunkStatus.byName((String)tagLevel.getString("Status"));
        if (chunkStatus != null) {
            return chunkStatus.getChunkType();
        }
        return ChunkType.PROTOCHUNK;
    }

    private static void readHeightmaps(LevelChunk chunk, CompoundTag chunkData) {
        CompoundTag tagHeightmaps = chunkData.getCompound("Heightmaps");
        for (Heightmap.Types type2 : ChunkStatus.FULL.heightmapsAfter()) {
            String heightmap = type2.getSerializationKey();
            if (!tagHeightmaps.contains(heightmap, 12)) continue;
            chunk.setHeightmap(type2, tagHeightmaps.getLongArray(heightmap));
        }
        Heightmap.primeHeightmaps((ChunkAccess)chunk, (Set)ChunkStatus.FULL.heightmapsAfter());
    }

    private static void readPostPocessings(LevelChunk chunk, CompoundTag chunkData) {
        ListTag tagPostProcessings = chunkData.getList("PostProcessing", 9);
        for (int i = 0; i < tagPostProcessings.size(); ++i) {
            ListTag listTag3 = tagPostProcessings.getList(i);
            for (int j = 0; j < listTag3.size(); ++j) {
                chunk.addPackedPostProcess(ShortList.of((short)listTag3.getShort(j)), i);
            }
        }
    }

    private static BlendingData readBlendingData(CompoundTag chunkData) {
        BlendingData blendingData = null;
        if (chunkData.contains("blending_data", 10)) {
            Dynamic blendingDataTag = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)chunkData.getCompound("blending_data"));
            blendingData = BlendingData.unpack((BlendingData.Packed)BlendingData.Packed.CODEC.parse(blendingDataTag).resultOrPartial(x$0 -> LOGGER.error((String)x$0, new Object[0])).orElse(null));
        }
        return blendingData;
    }

    public static CombinedChunkLightStorage readLight(ChunkAccess chunk, CompoundTag chunkData) {
        CombinedChunkLightStorage combinedStorage = new CombinedChunkLightStorage(ChunkWrapper.getInclusiveMinBuildHeight(chunk), ChunkWrapper.getExclusiveMaxBuildHeight(chunk));
        ChunkLightStorage blockLightStorage = combinedStorage.blockLightStorage;
        ChunkLightStorage skyLightStorage = combinedStorage.skyLightStorage;
        boolean foundSkyLight = false;
        Tag chunkSectionTags = chunkData.get("sections");
        if (chunkSectionTags == null) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("No sections found for chunk at pos [" + String.valueOf(chunk.getPos()) + "] chunk data may be out of date.", new Object[0]);
            }
            return null;
        }
        if (!(chunkSectionTags instanceof ListTag)) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("Chunk section tag list have unexpected type [" + chunkSectionTags.getClass().getName() + "], expected [" + ListTag.class.getName() + "].", new Object[0]);
            }
            return null;
        }
        ListTag chunkSectionListTag = (ListTag)chunkSectionTags;
        for (int sectionIndex = 0; sectionIndex < chunkSectionListTag.size(); ++sectionIndex) {
            Tag chunkSectionTag = chunkSectionListTag.get(sectionIndex);
            if (!(chunkSectionTag instanceof CompoundTag)) {
                if (!lightingSectionErrorLogged) {
                    lightingSectionErrorLogged = true;
                    LOGGER.error("Chunk section tag has an unexpected type [" + chunkSectionTag.getClass().getName() + "], expected [" + CompoundTag.class.getName() + "].", new Object[0]);
                }
                return null;
            }
            CompoundTag chunkSectionCompoundTag = (CompoundTag)chunkSectionTag;
            byte[] blockLightNibbleArray = chunkSectionCompoundTag.getByteArray("BlockLight");
            byte[] skyLightNibbleArray = chunkSectionCompoundTag.getByteArray("SkyLight");
            if (skyLightNibbleArray.length != 0) {
                foundSkyLight = true;
            }
            for (int relX = 0; relX < 16; ++relX) {
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relY = 0; relY < 16; ++relY) {
                        int skyLight;
                        int blockPosIndex = relY * 16 * 16 + relZ * 16 + relX;
                        byte blockLight = blockLightNibbleArray.length == 0 ? (byte)0 : ChunkLoader.getNibbleAtIndex(blockLightNibbleArray, blockPosIndex);
                        int n = skyLight = skyLightNibbleArray.length == 0 ? 0 : ChunkLoader.getNibbleAtIndex(skyLightNibbleArray, blockPosIndex);
                        if (skyLightNibbleArray.length == 0 && foundSkyLight) {
                            skyLight = 15;
                        }
                        int y = relY + sectionIndex * 16 + ChunkWrapper.getInclusiveMinBuildHeight(chunk);
                        blockLightStorage.set(relX, y, relZ, blockLight);
                        skyLightStorage.set(relX, y, relZ, skyLight);
                    }
                }
            }
        }
        return combinedStorage;
    }

    private static byte getNibbleAtIndex(byte[] arr, int index) {
        if (index % 2 == 0) {
            return (byte)(arr[index / 2] & 0xF);
        }
        return (byte)(arr[index / 2] >> 4 & 0xF);
    }

    private static void logBlockDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGER.warn("Unable to deserialize blocks for chunk section [" + chunkPos.x + ", " + sectionYIndex + ", " + chunkPos.z + "], error: [" + message + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
    }

    private static void logBiomeDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGER.warn("Unable to deserialize biomes for chunk section [" + chunkPos.x + ", " + sectionYIndex + ", " + chunkPos.z + "], error: [" + message + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
    }

    public static class CombinedChunkLightStorage {
        public ChunkLightStorage blockLightStorage;
        public ChunkLightStorage skyLightStorage;

        public CombinedChunkLightStorage(int minY, int maxY) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(minY, maxY);
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(minY, maxY);
        }
    }
}

